﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.EFR;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Data;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;

public partial class DoDFragmentDetails : BasePage 
{
    private DoDFragmentManager _manager = new DoDFragmentManager();
    protected readonly string DoDFragmentPage = "DoDFragment.aspx?patientId=";
                                                 
    protected void Page_Load(object sender, EventArgs e)
    {
        LoadBaseControls();

        if (!IsPostBack)
        {
            HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
            HiddenFieldLabID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentLabId"], false);
            HiddenFieldFragmentID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentId"], false);

            int dodFragmentId;

            if (int.TryParse(HiddenFieldFragmentID.Value, out dodFragmentId))
            {
                if (dodFragmentId > 0)
                {
                    BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > DoD Fragment Data > Edit Fragment";

                    SetupFragment(dodFragmentId);
                }
                else
                {
                    BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > DoD Fragment Data > Add Fragment";

                }
            }
        }

    }

    private void SetupFragment(int dodFragmentId)
    {
        DoDFragmentManager manager = new DoDFragmentManager();
        DOD_FRAGMENT fragment = manager.GetDoDFragmentById(dodFragmentId);
        if (fragment != null)
        {
            BaseControlTextBoxFragmentID.Text = fragment.FRAGMENT_ID_NUMBER;
            BaseControlTextBoxFragmentDesc.Text = fragment.FRAGMENT_DESCRIPTION;
            BaseControlTextBoxFragmentMass.Text = fragment.MASS;
            BaseControlTextBoxFragmentMassUOM.Text = fragment.MASS_UNITS;
            BaseControlTextBoxFragmentLength.Text = fragment.LENGTH;
            BaseControlTextBoxFragmentLengthUOM.Text = fragment.LENGTH_UNITS;
            BaseControlTextBoxFragmentHeight.Text = fragment.HEIGHT;
            BaseControlTextBoxFragmentHeightUOM.Text = fragment.HEIGHT_UNITS;
            BaseControlTextBoxFragmentWidth.Text = fragment.WIDTH;
            BaseControlTextBoxFragmentWidthUOM.Text = fragment.WIDTH_UNITS;
            BaseControlRadioButtonListFragmentRadioActiveInd.Text = fragment.RADIOACTIVEINDICATOR;
            BaseControTextBoxFragmentRadioActiveResults.Text = fragment.RADIOACTIVERESULTS;
            BaseControlTextBoxFragmentComments.Text = fragment.COMMENTS;
            if (fragment.TISSUE_SENT_FLAG.HasValue)
            {
                BaseControlRadioButtonListFragmentTissueIndicator.Text = (bool) fragment.TISSUE_SENT_FLAG ? "Yes" : "No";
            }
            BaseControlTextBoxFragmentTissueAssociated.Text = fragment.TISSUE_ASSOCIATED_WITH_FRAGMENT;
        }
    }

    private void LoadBaseControls()
    {
        RegistriesCommonManager commonManager = new RegistriesCommonManager();
        List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_DETAIL_DATA_ENTRY", EFRSharedConstant.EfrRegistryId);

        foreach (STD_GUI_CONTROL dbItem in controls)
        {
            Control userControl = null;

            userControl = PanelFragmentDetails.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl == null)
            {
                userControl = PanelDimensions.FindControl(dbItem.USER_CONTROL_ID);
            }

            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)EfrBaseControlType.TextBox)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                        dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH);
                }
                else if (dbItem.BASE_CONTROL_TYPE == (int)EfrBaseControlType.RadioButtonList)
                {
                    controls_BaseControlRadioButtonList baseControl = (controls_BaseControlRadioButtonList)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                        dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY);
                }
            }
        }
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    protected void ButtonBack_Click(object sender, EventArgs e)
    {
        //Response.Redirect(string.Format("DoDFragment.aspx?patientId={0}", GetValidStringValue(HiddenFieldPatientID.Value)));
        ResponseRedirect(DoDFragmentPage, GetValidStringValue(HiddenFieldPatientID.Value));
    }

    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        DOD_FRAGMENT fragment = LoadObjectFromControls();
        fragment = _manager.Update(fragment);
        HiddenFieldFragmentID.Value = fragment.DOD_FRAGMENT_ID.ToString();

       // Response.Redirect(string.Format("DoDFragment.aspx?patientId={0}", GetValidStringValue(HiddenFieldPatientID.Value)));
        ResponseRedirect(DoDFragmentPage, GetValidStringValue(HiddenFieldPatientID.Value));
    }
    private string GetValidStringValue(string pCurrentQueue)
    {
        string currentQueue = string.Empty;
        if (pCurrentQueue != null)
        {
            if (Regex.IsMatch(pCurrentQueue, "^[a-zA-Z0-9]*$"))
            {
                currentQueue = pCurrentQueue;
            }
        }
        return currentQueue;
    }
    private DOD_FRAGMENT LoadObjectFromControls()
    {
        DOD_FRAGMENT fragment = new DOD_FRAGMENT();

        if (!string.IsNullOrEmpty(HiddenFieldFragmentID.Value) && HiddenFieldFragmentID.Value != "0")
        {
            fragment = _manager.GetDoDFragmentById(Helpers.getIntFromString(HiddenFieldFragmentID.Value));
            fragment.SetAsChangeTrackingRoot(false);
            fragment.SetAsUpdateOnSubmit();
        }
        else
        {
            fragment.SetAsChangeTrackingRoot();
            fragment.SetAsInsertOnSubmit();
            fragment.DOD_FRAGMENT_LAB_ID = Helpers.getIntFromString(HiddenFieldLabID.Value);
        }

        fragment.FRAGMENT_ID_NUMBER = BaseControlTextBoxFragmentID.Text;
        fragment.FRAGMENT_DESCRIPTION  = BaseControlTextBoxFragmentDesc.Text;
        fragment.MASS = BaseControlTextBoxFragmentMass.Text;
        fragment.MASS_UNITS = BaseControlTextBoxFragmentMassUOM.Text;
        fragment.LENGTH = BaseControlTextBoxFragmentLength.Text;
        fragment.LENGTH_UNITS = BaseControlTextBoxFragmentLengthUOM.Text;
        fragment.HEIGHT = BaseControlTextBoxFragmentHeight.Text;
        fragment.HEIGHT_UNITS = BaseControlTextBoxFragmentHeightUOM.Text;
        fragment.WIDTH = BaseControlTextBoxFragmentWidth.Text;
        fragment.WIDTH_UNITS = BaseControlTextBoxFragmentWidthUOM.Text;
        if (!string.IsNullOrEmpty(BaseControlRadioButtonListFragmentRadioActiveInd.Text))
        {
            fragment.RADIOACTIVEINDICATOR = BaseControlRadioButtonListFragmentRadioActiveInd.Text;
        }
        else
        {
            fragment.RADIOACTIVEINDICATOR = null;
        }
        fragment.RADIOACTIVERESULTS = BaseControTextBoxFragmentRadioActiveResults.Text;
        fragment.COMMENTS = BaseControlTextBoxFragmentComments.Text;
        if (BaseControlRadioButtonListFragmentTissueIndicator.Text == "Yes")
        {
            fragment.TISSUE_SENT_FLAG = true;
        }
        else if (BaseControlRadioButtonListFragmentTissueIndicator.Text == "No")
        {
            fragment.TISSUE_SENT_FLAG = false;
        }
        else
        {
            fragment.TISSUE_SENT_FLAG = null;
        }

        fragment.TISSUE_ASSOCIATED_WITH_FRAGMENT = BaseControlTextBoxFragmentTissueAssociated.Text;

        return fragment;
    }

    private void ResponseRedirect(string destination, string queryString)
    {
        try
        {
            string queryStringValue = string.Empty;
            if (queryString != null)
            {
                queryStringValue = AntiXssEncoder.UrlEncode(queryString);
            }

            string destinationUrl = string.Concat(destination, queryStringValue);
            string currentHost = Request.Url.Host;
            if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            {
                //Response.Redirect(destinationUrl);
                Server.Transfer(destinationUrl);
            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in to redirect to Export page: - DOD Fragment page.");
        }

    }
}
